<?php
header('Content-Type: application/json');
header('Access-Control-Allow-Origin: *');

// Tipo de API: ahora siempre usaremos iTunes
$ApiType = "itunes";

// Valores por defecto.
$defaultArtist = "No Disponible";
$defaultTitle  = "Artista";
$defaultArtwork = 'api/default.png';

// Lista de anuncios personalizados con sus respectivas imágenes
$ads = [
    "CONTACTENOS: +51975959016" => [
        "artist"  => "URL BLOQUEADA",
        "artwork" => "https://nexostreaming.com/wp-content/uploads/2025/02/bloqueada.png"
    ]
];

$GetDataInput  = filter_input(INPUT_GET, 'query');
$FilterReplace = str_replace(array('.mp3', '.aac', '.wav'), '', $GetDataInput);

/**
 * Detecta si es un anuncio configurado.
 */
function checkForAd($query, $ads)
{
    foreach ($ads as $songTitle => $adData) {
        if (stripos($query, $songTitle) !== false && stripos($query, $adData['artist']) !== false) {
            return json_encode([
                'results' => [
                    'artist'  => $adData['artist'],
                    'title'   => $songTitle,
                    'artwork' => $adData['artwork'],
                    'youtube' => null
                ]
            ]);
        }
    }
    return null;
}

/**
 * Scraping simple de YouTube para obtener el primer videoId.
 */
function getYoutubeIdScraping($artist, $title) {
    $query = urlencode(trim($artist . " " . $title));
    $url = "https://www.youtube.com/results?search_query={$query}";

    $opts = [
        "http" => [
            "header" => "User-Agent: Mozilla/5.0 (compatible; radioapi/1.0)\r\n"
        ]
    ];
    $context = stream_context_create($opts);
    $html = @file_get_contents($url, false, $context);

    if ($html === false) {
        return null;
    }

    if (preg_match('/"videoId":"([a-zA-Z0-9_-]{11})"/', $html, $matches)) {
        return $matches[1];
    }

    return null;
}

/**
 * Obtiene datos desde iTunes con portada en alta resolución + YouTube.
 */
function getItunes($searchQuery, $defaultArtist, $defaultTitle, $defaultArtwork)
{
    $url = "https://itunes.apple.com/search?term=" . urlencode($searchQuery) . "&entity=song&limit=1";
    $data = @file_get_contents($url);
    $json = json_decode($data);

    if (!empty($json->results[0])) {
        $result = $json->results[0];

        $artist  = $result->artistName ?? $defaultArtist;
        $title   = $result->trackName ?? $defaultTitle;

        // Modificar tamaño de la imagen: 100x100 → 4000x4000
        if (!empty($result->artworkUrl100)) {
            $artwork = str_replace('100x100bb.jpg', '1000x1000bb.jpg', $result->artworkUrl100);
        } else {
            $artwork = $defaultArtwork;
        }

        $album   = $result->collectionName ?? "Desconocido";
        $year    = isset($result->releaseDate) ? substr($result->releaseDate, 0, 4) : "Desconocido";
        $genre   = $result->primaryGenreName ?? "Desconocido";
        $stream  = $result->trackViewUrl ?? null;

        // Buscar YouTube con scraping
        $youtube = getYoutubeIdScraping($artist, $title);

        return json_encode([
            'results' => [
                'artist'  => $artist,
                'title'   => $title,
                'artwork' => $artwork,
                'stream'  => $stream,
                'album'   => $album,
                'year'    => $year,
                'genre'   => $genre,
                'youtube' => $youtube
            ]
        ]);
    }

    // Si no encuentra nada
    return json_encode([
        'results' => [
            'artist'  => $defaultArtist,
            'title'   => $defaultTitle,
            'artwork' => $defaultArtwork,
            'youtube' => null
        ]
    ]);
}

// --- Ejecución principal ---
if (empty($GetDataInput)) {
    echo json_encode([
        'results' => [
            'artist'  => $defaultArtist,
            'title'   => $defaultTitle,
            'artwork' => $defaultArtwork,
            'youtube' => null
        ]
    ]);
    exit;
}

// Revisar si es anuncio
$adResponse = checkForAd($FilterReplace, $ads);
if ($adResponse) {
    echo $adResponse;
    exit;
}

// Usar iTunes directamente
if ($ApiType === "itunes") {
    echo getItunes($FilterReplace, $defaultArtist, $defaultTitle, $defaultArtwork);
}
?>
